/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.mixin.Eni;

import com.aizistral.enigmaticlegacy.api.capabilities.IPlaytimeCounter;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.CursedRing;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.hoshino.cti.client.cache.SevenCurse;
import com.hoshino.cti.netwrok.CtiPacketHandler;
import com.hoshino.cti.netwrok.packet.ServerCursePacket;
import com.hoshino.cti.register.CtiModifiers;
import com.hoshino.cti.util.CurseStage;
import com.hoshino.cti.util.CurseUtil;
import com.hoshino.cti.util.method.GetModifierLevel;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.SlotContext;

@Mixin(value={CursedRing.class}, remap=false)
public abstract class CurseRingMixin
extends ItemBaseCurio {
    @Shadow
    public static Omniconfig.PerhapsParameter painMultiplier;
    @Shadow
    public static Omniconfig.PerhapsParameter armorDebuff;
    @Shadow
    public static Omniconfig.PerhapsParameter monsterDamageDebuff;
    @Shadow
    public static Omniconfig.IntParameter lootingBonus;
    @Shadow
    public static Omniconfig.IntParameter fortuneBonus;
    @Shadow
    public static Omniconfig.PerhapsParameter experienceBonus;
    @Shadow
    public static Omniconfig.IntParameter enchantingBonus;
    @Shadow
    public static Omniconfig.BooleanParameter enableLore;

    @Inject(method={"curioTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/EnderMan;m_6710_(Lnet/minecraft/world/entity/LivingEntity;)V")}, cancellable=true)
    private void angryEnderMan(SlotContext context, ItemStack stack, CallbackInfo ci) {
        boolean shouldNotBeAngry;
        LivingEntity livingEntity = context.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        boolean bl = shouldNotBeAngry = player.m_9236_().m_46461_() || GetModifierLevel.EquipHasModifierlevel((LivingEntity)player, CtiModifiers.end_slayer.getId()) || this.cti$isInfancy(player);
        if (shouldNotBeAngry) {
            ci.cancel();
        }
    }

    @Inject(method={"curioTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/NeutralMob;m_6710_(Lnet/minecraft/world/entity/LivingEntity;)V")}, cancellable=true)
    private void angryOtherMob(SlotContext context, ItemStack stack, CallbackInfo ci) {
        boolean shouldNotBeAngry;
        LivingEntity livingEntity = context.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        boolean bl = shouldNotBeAngry = player.f_19853_.m_46461_() || this.cti$isInfancy(player);
        if (shouldNotBeAngry) {
            ci.cancel();
        }
    }

    @Inject(method={"curioTick"}, at={@At(value="HEAD")})
    private void curioTick(SlotContext context, ItemStack stack, CallbackInfo ci) {
        CompoundTag data = stack.m_41784_();
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player) {
            int resoluteTime;
            Player player = (Player)livingEntity;
            int time = CurseUtil.getPunishTime(player);
            if (time > 0) {
                if (player.f_19797_ % 20 == 0) {
                    data.m_128405_("punish_time", time - 1);
                }
            } else {
                Level worldIn = context.entity().m_9236_();
                long worldTime = worldIn.m_46467_();
                resoluteTime = data.m_128451_("resolute");
                if (worldTime % 24000L == 0L) {
                    data.m_128405_("resolute", Math.min(3, resoluteTime + 1));
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                int punishTime = CurseUtil.getPunishTime(player);
                int deathFre = CurseUtil.getDeathFrequency(player);
                resoluteTime = CurseUtil.getResoluteTime(player);
                long curseTime = CurseUtil.curseTime(player);
                CtiPacketHandler.sendToPlayer(new ServerCursePacket(punishTime, deathFre, resoluteTime), serverPlayer);
                this.cti$CheckStage(curseTime, serverPlayer);
            }
        }
    }

    @Unique
    private void cti$CheckStage(long curseTime, ServerPlayer serverPlayer) {
        CurseStage[] array;
        if (curseTime % 24000L != 0L) {
            return;
        }
        for (CurseStage stage : array = CurseStage.values()) {
            if (curseTime != stage.curseTime) continue;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket(stage.title));
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket(stage.subTitle));
            serverPlayer.m_213846_((Component)Component.m_237113_((String)(serverPlayer.m_7755_() + ",\u4f60\u5df2\u8fdb\u5165" + stage.title.getString() + "\u9636\u6bb5")));
            serverPlayer.m_213846_(stage.description);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Overwrite
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing3");
            if (painMultiplier.getValue().asMultiplier() == 2.0) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing4");
            } else {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing4_alt", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{painMultiplier + "%"});
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing5");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing6", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{armorDebuff + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing7", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{monsterDamageDebuff + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing8");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing9");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing10");
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                int time = SevenCurse.getPunishTime();
                int frequency = SevenCurse.getPunishFre();
                int resoluteTime = SevenCurse.getResoluteTime();
                int attackWeakValue = Math.round((1.0f - 1.0f / (float)Math.max(frequency - 2, 1)) * 1000.0f) / 10;
                String string1 = "\u5f53\u524d\u4f60\u5df2\u7ecf\u7d2f\u8ba1\u6b7b\u4ea1" + frequency + "\u6b21";
                String string2 = "\u7531\u4e8e\u4f60\u7684\u6b7b\u4ea1,\u4f60\u53d7\u5230\u7684\u4f24\u5bb3\u989d\u5916\u589e\u52a0" + Math.max((float)(frequency - 3) * 0.5f * 100.0f, 0.0f) + "%,\u9020\u6210\u7684\u4f24\u5bb3\u964d\u4f4e" + attackWeakValue + "%";
                String string3 = "\u5728" + time + "\u79d2\u540e,\u4f1a\u7ed3\u675f\u7075\u9b42\u7834\u788e\u5bf9\u4f60\u7684\u5f71\u54cd";
                String string7 = "\u7075\u9b42\u7834\u788e\u5f71\u54cd\u5df2\u7ed3\u675f\uff0c\u6682\u65f6\u7684";
                String string4 = "\u5f53\u524d\u575a\u6bc5\u5c42\u6570\u4e3a" + resoluteTime + "\u5c42,\u4f1a\u51cf\u5c11\u53d7\u5230\u7684" + resoluteTime * 6 + "%\u4f24\u5bb3";
                String string5 = "\u5982\u679c\u4f60\u6b7b\u4ea1\u4e86\u4f1a\u6e05\u9664\u6240\u6709\u7684\u575a\u6bc5\u5c42\u6570!";
                long resoluteWait = 24000L - player.m_9236_().m_46467_() % 24000L;
                String string6 = "\u4e0b\u4e00\u5c42\u575a\u6bc5\u5c42\u6570\u7eed\u4e0a\u5012\u8ba1\u65f6" + resoluteWait;
                list.add((Component)Component.m_237113_((String)string1).m_130938_(style -> style.m_178520_(16728924)));
                list.add((Component)Component.m_237113_((String)string2).m_130938_(style -> style.m_178520_(16728924)));
                if (time > 0) {
                    list.add((Component)Component.m_237113_((String)string3).m_130938_(style -> style.m_178520_(16728924)));
                } else {
                    list.add((Component)Component.m_237113_((String)string7).m_130938_(style -> style.m_178520_(16728924)));
                }
                list.add((Component)Component.m_237113_((String)string4).m_130938_(style -> style.m_178520_(0xFFAA7F)));
                list.add((Component)Component.m_237113_((String)string5).m_130938_(style -> style.m_178520_(0xFFAA7F)));
                if (resoluteTime < 3) {
                    if (time > 0) {
                        list.add((Component)Component.m_237113_((String)"\u5728\u4f60\u7684\u6b7b\u4ea1\u60e9\u7f5a\u7ed3\u675f\u524d\u65e0\u6cd5\u83b7\u5f97\u575a\u6bc5\u5c42\u6570!").m_130938_(style -> style.m_178520_(16728924)));
                    } else {
                        list.add((Component)Component.m_237113_((String)string6).m_130938_(style -> style.m_178520_(0xFFAA7F)));
                    }
                }
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing11");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing12", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{lootingBonus.getValue() - 1 + resoluteTime});
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing13", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{fortuneBonus.getValue() - 1 + resoluteTime});
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing14", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{experienceBonus + "%"});
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing15", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{enchantingBonus});
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing16");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing17");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRing18");
            }
        } else {
            if (enableLore.getValue()) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRingLore1");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRingLore2");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRingLore3");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRingLore4");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRingLore5");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRingLore6");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.cursedRingLore7");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.eternallyBound1");
            if (Minecraft.m_91087_().f_91074_ != null && SuperpositionHandler.canUnequipBoundRelics((Player)Minecraft.m_91087_().f_91074_)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.eternallyBound2_creative");
            } else {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.eternallyBound2");
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Unique
    private boolean cti$isInfancy(Player player) {
        IPlaytimeCounter counter = IPlaytimeCounter.get((Player)player);
        return counter.getTimeWithCurses() < 96000L;
    }

    @Unique
    private long cti$getCurseTime(Player player) {
        IPlaytimeCounter counter = IPlaytimeCounter.get((Player)player);
        return counter.getTimeWithCurses();
    }

    @Inject(method={"getFortuneLevel"}, at={@At(value="RETURN")}, cancellable=true)
    private void fortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack curio, CallbackInfoReturnable<Integer> cir) {
        int resoluteTime = curio.m_41784_().m_128451_("resolute");
        cir.setReturnValue((Object)(super.getFortuneLevel(slotContext, lootContext, curio) + fortuneBonus.getValue() - 1 + resoluteTime));
    }

    @Inject(method={"getLootingLevel"}, at={@At(value="RETURN")}, cancellable=true)
    private void lootLevel(SlotContext slotContext, DamageSource source, LivingEntity target, int baseLooting, ItemStack curio, CallbackInfoReturnable<Integer> cir) {
        int resoluteTime = curio.m_41784_().m_128451_("resolute");
        cir.setReturnValue((Object)(super.getLootingLevel(slotContext, source, target, baseLooting, curio) + lootingBonus.getValue() - 1 + resoluteTime));
    }
}

